#!/bin/bash

if [[ $(id -u) -eq 0 ]]; then
    echo "Script is running as root. Run without sudo."
    exit 1  # Quit the script
fi

# Define variables
APP_NAME="Video Downloader"
INSTALL_DIR="/opt/$APP_NAME"
DESKTOP_FILE="$HOME/.local/share/applications/$APP_NAME.desktop"

# Function to display usage instructions
usage() {
    echo "Usage: $0 [options]"
    echo "Options:"
    echo "  -h, --help    Display this help message"
    exit 1
}

# Parse command-line arguments
while [[ "$#" -gt 0 ]]; do
    case "$1" in
        -h|--help) usage ;;
        *) echo "Unknown option: $1"; usage ;;
    esac
    shift
done

# Function to remove a directory
remove_directory() {
    local directory="$1"
    if [ -d "$directory" ]; then
        echo "Removing directory: $directory"
        sudo rm -rf "$directory"
    fi
}

# Function to remove a file
remove_file() {
    local file="$1"
    if [ -f "$file" ]; then
        echo "Removing file: $file"
        sudo rm -f "$file"
    fi
}

# Remove the installation directory
remove_directory "$INSTALL_DIR"

# Remove the desktop file
remove_file "$DESKTOP_FILE"


# Notify the user
echo "Uninstallation completed."

# End of script
